/*** 1.   ũƮ ***/

SELECT CASE WHEN RIGHT(CONVERT(VARCHAR,a.number),1) <= 8 THEN 'A' ELSE 'B' END ID
	, CONVERT(VARCHAR,a.number) ProductNumber 
	, CONVERT(VARCHAR,b.number) CatalogNumber
	, CONVERT(DATE,DATEADD(DD,a.number+b.number,'2010-01-01'),0) ModifiedDate
INTO TB_PartitionIncremental
FROM master..spt_values a, (SELECT number 
			     FROM master..spt_values    	 
			     WHERE type ='P') b 
WHERE a.type = 'P'

CREATE CLUSTERED INDEX CIDX_PartitionIncremental ON TB_PartitionIncremental(ModifiedDate)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

UPDATE TB_PartitionIncremental SET ModifiedDate = '2020-04-12' 
WHERE ModifiedDate BETWEEN '2020-01-01' AND '2021-01-01' 

UPDATE STATISTICS TB_PartitionIncremental (CIDX_PartitionIncremental) WITH FULLSCAN
GO


/*** 6. [TO-BE]   ***/

--Ƽ ̺ 籸 
BEGIN TRANSACTION

DROP INDEX CIDX_PartitionIncremental ON TB_PartitionIncremental

CREATE PARTITION FUNCTION [Partition_FN_TB_PI](DATE) 
AS RANGE LEFT FOR VALUES (N'2011-01-01', N'2012-01-01', N'2013-01-01', N'2014-01-01'
			 , N'2015-01-01', N'2016-01-01', N'2017-01-01', N'2018-01-01'
			 , N'2019-01-01', N'2020-01-01', N'2021-01-01')

CREATE PARTITION SCHEME [Partition_Scheme_TB_PI] 
AS PARTITION [Partition_FN_TB_PI] TO ([PRIMARY], [PRIMARY], [PRIMARY], [PRIMARY]						    
									, [PRIMARY], [PRIMARY], [PRIMARY], [PRIMARY]						    
									, [PRIMARY], [PRIMARY], [PRIMARY], [PRIMARY])

CREATE CLUSTERED INDEX CIDX_PartitionIncremental 
ON TB_PartitionIncremental(ModifiedDate) ON Partition_Scheme_TB_PI(ModifiedDate)
COMMIT TRANSACTION
GO

--Ƽǵ Ŭ ε Incremental ɼ Ͽ  Ʈ
UPDATE STATISTICS TB_PartitionIncremental(CIDX_PartitionIncremental) 
WITH FULLSCAN, INCREMENTAL = ON
GO

-- SQL  
UPDATE TB_PartitionIncremental SET ModifiedDate = '2020-04-12' 
WHERE ModifiedDate BETWEEN '2020-01-01' AND '2021-01-01' 

UPDATE STATISTICS TB_PartitionIncremental (CIDX_PartitionIncremental) 
WITH RESAMPLE ON PARTITIONS (11)
GO